<?php
class Photos_Controller {
  /**
   * @var RouterAbstract
   */
  protected $router = false;
  /**
   * Wykonuje nasze żądanie
   * 
   * @param string $url 
   */
  public function dispatch($url, $default_data = array())
  {
    try {
      if (!$this->router) {
        throw new Exception("Router not set");
      }
      $route = $this->router->getRoute($url);
      $controller = ucfirst($route['controller']);
      $action = ucfirst($route['action']);
      unset($route['controller']);
      unset($route['action']);
      // Pobranie modelu
      $model = $this->getModel($controller);
      $data = $model->{$action}($route);
      $data = $data + $default_data;
      // Pobranie widoku
      $view = $this->getView($controller, $action);
      echo $view->render($data);
    } catch (Exception $e) {
      try {
        if ($url != '/error') {
          $data = array('message' => $e->getMessage());
          $this->dispatch("/error", $data);
        } else {
          throw new Exception("Błąd niezdefiniowanej trasy");
        }
      } catch (Exception $e) {
        echo "<h1>Wystąpił nieznany błąd.</h1>";
      }
    }
  }
  /**
   * Ustawia router
   * 
   * @param RouterAbstract $router 
   */
  public function setRouter(RouterAbstract $router)
  {
    $this->router = $router;
  }
  /**
   * Pobiera obiekt klasę modelu
   * 
   * @param string $name
   * @return mixed
   */
  protected function getModel($name)
  {
    $name .= '_Model';
    $this->includeClass($name);
    return new $name;
  }
  /**
   * Pobiera obiekt widoku
   * 
   * @param string $name
   * @param string $action
   * @return mixed
   */
  protected function getView($name, $action)
  {
    $name .= '_' .$action. 'View';
    $this->includeClass($name);
    return new $name;
  }
  /**
   * Dołącza klasę korzystając z nazewnictwa w stylu PEAR
   * 
   * @param string $name 
   * @return void
   * @throws Exception
   */
  protected function includeClass($name)
  {
    $file = str_replace('_', DIRECTORY_SEPARATOR, $name) . '.php';
    if (!file_exists($file)) {
      throw new Exception("Nie znaleziono klasy!");
    }
    require_once $file;
  }
}
?>